<?php

declare(strict_types=1);

namespace Erlage\Photogram\Data\Models\Admin;

trait TraitAdminGetters
{
    use TraitAdminProperties;

    /*
    |--------------------------------------------------------------------------
    | Note! We could have all our properties as public. The reason for using 
    | getters is that static checking doesn't work well for undefined properties
    | because of dynamic properties in PHP(__set & __get methods)
    |--------------------------------------------------------------------------
    */

    final public function getId(): string
    {
        return $this -> id;
    }

    public function getEmail(): string
    {
        return $this -> email;
    }

    public function getUsername(): string
    {
        return $this -> username;
    }

    public function getPassword(): string
    {
        return $this -> password;
    }

    public function getMetaAccess(): string
    {
        return $this -> metaAccess;
    }

    public function getMetaLastActive(): string
    {
        return $this -> metaLastActive;
    }

    public function getStampRegistration(): string
    {
        return $this -> stampRegistration;
    }

    public function getStampLastUpdate(): string
    {
        return $this -> stampLastUpdate;
    }
}
